package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ReplicationControllerListFluent<A extends ReplicationControllerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ReplicationController... items);
    public A removeFromItems(ReplicationController... items);
    public List<ReplicationController> getItems();
    public A withItems(List<ReplicationController> items);
    public A withItems(ReplicationController... items);
    public ReplicationControllerListFluent.ItemsNested<A> addNewItem();
    public ReplicationControllerListFluent.ItemsNested<A> addNewItemLike(ReplicationController item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ReplicationControllerListFluent.MetadataNested<A> withNewMetadata();
    public ReplicationControllerListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ReplicationControllerListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ReplicationControllerFluent<ReplicationControllerListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ReplicationControllerListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
