package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeFluent<A extends PersistentVolumeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PersistentVolumeFluent.MetadataNested<A> editMetadata();
    public PersistentVolumeSpec getSpec();
    public A withSpec(PersistentVolumeSpec spec);
    public PersistentVolumeFluent.SpecNested<A> withNewSpec();
    public PersistentVolumeFluent.SpecNested<A> withNewSpecLike(PersistentVolumeSpec item);
    public PersistentVolumeFluent.SpecNested<A> editSpec();
    public PersistentVolumeStatus getStatus();
    public A withStatus(PersistentVolumeStatus status);
    public PersistentVolumeFluent.StatusNested<A> withNewStatus();
    public PersistentVolumeFluent.StatusNested<A> withNewStatusLike(PersistentVolumeStatus item);
    public PersistentVolumeFluent.StatusNested<A> editStatus();
    public A withNewStatus(String message,String phase,String reason);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PersistentVolumeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PersistentVolumeSpecFluent<PersistentVolumeFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,PersistentVolumeStatusFluent<PersistentVolumeFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
