package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamespaceFluent<A extends NamespaceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public NamespaceFluent.MetadataNested<A> withNewMetadata();
    public NamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NamespaceFluent.MetadataNested<A> editMetadata();
    public NamespaceSpec getSpec();
    public A withSpec(NamespaceSpec spec);
    public NamespaceFluent.SpecNested<A> withNewSpec();
    public NamespaceFluent.SpecNested<A> withNewSpecLike(NamespaceSpec item);
    public NamespaceFluent.SpecNested<A> editSpec();
    public NamespaceStatus getStatus();
    public A withStatus(NamespaceStatus status);
    public NamespaceFluent.StatusNested<A> withNewStatus();
    public NamespaceFluent.StatusNested<A> withNewStatusLike(NamespaceStatus item);
    public NamespaceFluent.StatusNested<A> editStatus();
    public A withNewStatus(String phase);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NamespaceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,NamespaceSpecFluent<NamespaceFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,NamespaceStatusFluent<NamespaceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
