package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EventListFluent<A extends EventListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Event... items);
    public A removeFromItems(Event... items);
    public List<Event> getItems();
    public A withItems(List<Event> items);
    public A withItems(Event... items);
    public EventListFluent.ItemsNested<A> addNewItem();
    public EventListFluent.ItemsNested<A> addNewItemLike(Event item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public EventListFluent.MetadataNested<A> withNewMetadata();
    public EventListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public EventListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,EventFluent<EventListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<EventListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
