package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class EnvVarSourceBuilder extends EnvVarSourceFluentImpl<EnvVarSourceBuilder> implements VisitableBuilder<EnvVarSource,EnvVarSourceBuilder>{

    EnvVarSourceFluent<?> fluent;
    Boolean validationEnabled;

    public EnvVarSourceBuilder(){
            this(true);
    }
    public EnvVarSourceBuilder(Boolean validationEnabled){
            this(new EnvVarSource(), validationEnabled);
    }
    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent){
            this(fluent, true);
    }
    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvVarSource(), validationEnabled);
    }
    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,EnvVarSource instance){
            this(fluent, instance, true);
    }
    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,EnvVarSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
            fluent.withFieldRef(instance.getFieldRef()); 
            fluent.withResourceFieldRef(instance.getResourceFieldRef()); 
            fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvVarSourceBuilder(EnvVarSource instance){
            this(instance,true);
    }
    public EnvVarSourceBuilder(EnvVarSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
            this.withFieldRef(instance.getFieldRef()); 
            this.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.withSecretKeyRef(instance.getSecretKeyRef()); 
            this.validationEnabled = validationEnabled; 
    }

    public EnvVarSource build(){
            EnvVarSource buildable = new EnvVarSource(fluent.getConfigMapKeyRef(),fluent.getFieldRef(),fluent.getResourceFieldRef(),fluent.getSecretKeyRef());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvVarSourceBuilder that = (EnvVarSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
