package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ContainerStatusFluent<A extends ContainerStatusFluent<A>> extends Fluent<A>{


    public String getContainerID();
    public A withContainerID(String containerID);
    public String getImage();
    public A withImage(String image);
    public String getImageID();
    public A withImageID(String imageID);
    public ContainerState getLastState();
    public A withLastState(ContainerState lastState);
    public ContainerStatusFluent.LastStateNested<A> withNewLastState();
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item);
    public ContainerStatusFluent.LastStateNested<A> editLastState();
    public String getName();
    public A withName(String name);
    public Boolean isReady();
    public A withReady(Boolean ready);
    public Integer getRestartCount();
    public A withRestartCount(Integer restartCount);
    public ContainerState getState();
    public A withState(ContainerState state);
    public ContainerStatusFluent.StateNested<A> withNewState();
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item);
    public ContainerStatusFluent.StateNested<A> editState();

    public interface LastStateNested<N> extends Nested<N>,ContainerStateFluent<ContainerStatusFluent.LastStateNested<N>>{

        
    public N endLastState();    public N and();
}
    public interface StateNested<N> extends Nested<N>,ContainerStateFluent<ContainerStatusFluent.StateNested<N>>{

        
    public N and();    public N endState();
}


}
