package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface ContainerImageFluent<A extends ContainerImageFluent<A>> extends Fluent<A>{


    public A addToNames(String... items);
    public A removeFromNames(String... items);
    public List<String> getNames();
    public A withNames(List<String> names);
    public A withNames(String... names);
    public Long getSizeBytes();
    public A withSizeBytes(Long sizeBytes);



}
