package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class SourceRevisionFluentImpl<A extends SourceRevisionFluent<A>> extends BaseFluent<A> implements SourceRevisionFluent<A>{

    private VisitableBuilder<? extends GitSourceRevision,?> git;
    private String type;

    public SourceRevisionFluentImpl(){
    }
    public SourceRevisionFluentImpl(SourceRevision instance){
            this.withGit(instance.getGit()); 
            this.withType(instance.getType()); 
    }

    public GitSourceRevision getGit(){
            return this.git!=null?this.git.build():null;
    }

    public A withGit(GitSourceRevision git){
            if (git!=null){ this.git= new GitSourceRevisionBuilder(git); _visitables.add(this.git);} return (A) this;
    }

    public SourceRevisionFluent.GitNested<A> withNewGit(){
            return new GitNestedImpl();
    }

    public SourceRevisionFluent.GitNested<A> withNewGitLike(GitSourceRevision item){
            return new GitNestedImpl(item);
    }

    public SourceRevisionFluent.GitNested<A> editGit(){
            return withNewGitLike(getGit());
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SourceRevisionFluentImpl that = (SourceRevisionFluentImpl) o;
            if (git != null ? !git.equals(that.git) :that.git != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class GitNestedImpl<N> extends GitSourceRevisionFluentImpl<SourceRevisionFluent.GitNested<N>> implements SourceRevisionFluent.GitNested<N>,Nested<N>{

            private final GitSourceRevisionBuilder builder;
    
            GitNestedImpl(){
                    this.builder = new GitSourceRevisionBuilder(this);
            }
            GitNestedImpl(GitSourceRevision item){
                    this.builder = new GitSourceRevisionBuilder(this, item);
            }
    
    public N and(){
            return (N) SourceRevisionFluentImpl.this.withGit(builder.build());
    }
    public N endGit(){
            return and();
    }

}


}
