package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PolicyBindingListBuilder extends PolicyBindingListFluentImpl<PolicyBindingListBuilder> implements VisitableBuilder<PolicyBindingList,PolicyBindingListBuilder>{

    PolicyBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBindingListBuilder(){
            this(true);
    }
    public PolicyBindingListBuilder(Boolean validationEnabled){
            this(new PolicyBindingList(), validationEnabled);
    }
    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyBindingList(), validationEnabled);
    }
    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent,PolicyBindingList instance){
            this(fluent, instance, true);
    }
    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent,PolicyBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBindingListBuilder(PolicyBindingList instance){
            this(instance,true);
    }
    public PolicyBindingListBuilder(PolicyBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public PolicyBindingList build(){
            PolicyBindingList buildable = new PolicyBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyBindingListBuilder that = (PolicyBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
