package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BuildTriggerPolicyFluent<A extends BuildTriggerPolicyFluent<A>> extends Fluent<A>{


    public WebHookTrigger getGeneric();
    public A withGeneric(WebHookTrigger generic);
    public BuildTriggerPolicyFluent.GenericNested<A> withNewGeneric();
    public BuildTriggerPolicyFluent.GenericNested<A> withNewGenericLike(WebHookTrigger item);
    public BuildTriggerPolicyFluent.GenericNested<A> editGeneric();
    public A withNewGeneric(Boolean allowEnv,String secret);
    public WebHookTrigger getGithub();
    public A withGithub(WebHookTrigger github);
    public BuildTriggerPolicyFluent.GithubNested<A> withNewGithub();
    public BuildTriggerPolicyFluent.GithubNested<A> withNewGithubLike(WebHookTrigger item);
    public BuildTriggerPolicyFluent.GithubNested<A> editGithub();
    public A withNewGithub(Boolean allowEnv,String secret);
    public ImageChangeTrigger getImageChange();
    public A withImageChange(ImageChangeTrigger imageChange);
    public BuildTriggerPolicyFluent.ImageChangeNested<A> withNewImageChange();
    public BuildTriggerPolicyFluent.ImageChangeNested<A> withNewImageChangeLike(ImageChangeTrigger item);
    public BuildTriggerPolicyFluent.ImageChangeNested<A> editImageChange();
    public String getType();
    public A withType(String type);

    public interface GenericNested<N> extends Nested<N>,WebHookTriggerFluent<BuildTriggerPolicyFluent.GenericNested<N>>{

        
    public N endGeneric();    public N and();
}
    public interface GithubNested<N> extends Nested<N>,WebHookTriggerFluent<BuildTriggerPolicyFluent.GithubNested<N>>{

        
    public N endGithub();    public N and();
}
    public interface ImageChangeNested<N> extends Nested<N>,ImageChangeTriggerFluent<BuildTriggerPolicyFluent.ImageChangeNested<N>>{

        
    public N and();    public N endImageChange();
}


}
