package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public class BuildSourceFluentImpl<A extends BuildSourceFluent<A>> extends BaseFluent<A> implements BuildSourceFluent<A>{

    private VisitableBuilder<? extends BinaryBuildSource,?> binary;
    private String contextDir;
    private String dockerfile;
    private VisitableBuilder<? extends GitBuildSource,?> git;
    private List<VisitableBuilder<? extends ImageSource,?>> images =  new ArrayList<VisitableBuilder<? extends ImageSource,?>>();
    private List<VisitableBuilder<? extends SecretBuildSource,?>> secrets =  new ArrayList<VisitableBuilder<? extends SecretBuildSource,?>>();
    private VisitableBuilder<? extends LocalObjectReference,?> sourceSecret;
    private String type;

    public BuildSourceFluentImpl(){
    }
    public BuildSourceFluentImpl(BuildSource instance){
            this.withBinary(instance.getBinary()); 
            this.withContextDir(instance.getContextDir()); 
            this.withDockerfile(instance.getDockerfile()); 
            this.withGit(instance.getGit()); 
            this.withImages(instance.getImages()); 
            this.withSecrets(instance.getSecrets()); 
            this.withSourceSecret(instance.getSourceSecret()); 
            this.withType(instance.getType()); 
    }

    public BinaryBuildSource getBinary(){
            return this.binary!=null?this.binary.build():null;
    }

    public A withBinary(BinaryBuildSource binary){
            if (binary!=null){ this.binary= new BinaryBuildSourceBuilder(binary); _visitables.add(this.binary);} return (A) this;
    }

    public BuildSourceFluent.BinaryNested<A> withNewBinary(){
            return new BinaryNestedImpl();
    }

    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item){
            return new BinaryNestedImpl(item);
    }

    public BuildSourceFluent.BinaryNested<A> editBinary(){
            return withNewBinaryLike(getBinary());
    }

    public A withNewBinary(String asFile){
            return (A)withBinary(new BinaryBuildSource(asFile));
    }

    public String getContextDir(){
            return this.contextDir;
    }

    public A withContextDir(String contextDir){
            this.contextDir=contextDir; return (A) this;
    }

    public String getDockerfile(){
            return this.dockerfile;
    }

    public A withDockerfile(String dockerfile){
            this.dockerfile=dockerfile; return (A) this;
    }

    public GitBuildSource getGit(){
            return this.git!=null?this.git.build():null;
    }

    public A withGit(GitBuildSource git){
            if (git!=null){ this.git= new GitBuildSourceBuilder(git); _visitables.add(this.git);} return (A) this;
    }

    public BuildSourceFluent.GitNested<A> withNewGit(){
            return new GitNestedImpl();
    }

    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item){
            return new GitNestedImpl(item);
    }

    public BuildSourceFluent.GitNested<A> editGit(){
            return withNewGitLike(getGit());
    }

    public A withNewGit(String httpProxy,String httpsProxy,String ref,String uri){
            return (A)withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }

    public A addToImages(ImageSource... items){
            for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.add(builder);this.images.add(builder);} return (A)this;
    }

    public A removeFromImages(ImageSource... items){
            for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.remove(builder);this.images.remove(builder);} return (A)this;
    }

    public List<ImageSource> getImages(){
            return build(images);
    }

    public A withImages(List<ImageSource> images){
            this.images.clear();
            if (images != null) {for (ImageSource item : images){this.addToImages(item);}} return (A) this;
    }

    public A withImages(ImageSource... images){
            this.images.clear(); if (images != null) {for (ImageSource item :images){ this.addToImages(item);}} return (A) this;
    }

    public BuildSourceFluent.ImagesNested<A> addNewImage(){
            return new ImagesNestedImpl();
    }

    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item){
            return new ImagesNestedImpl(item);
    }

    public A addToSecrets(SecretBuildSource... items){
            for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(SecretBuildSource... items){
            for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.remove(builder);this.secrets.remove(builder);} return (A)this;
    }

    public List<SecretBuildSource> getSecrets(){
            return build(secrets);
    }

    public A withSecrets(List<SecretBuildSource> secrets){
            this.secrets.clear();
            if (secrets != null) {for (SecretBuildSource item : secrets){this.addToSecrets(item);}} return (A) this;
    }

    public A withSecrets(SecretBuildSource... secrets){
            this.secrets.clear(); if (secrets != null) {for (SecretBuildSource item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public BuildSourceFluent.SecretsNested<A> addNewSecret(){
            return new SecretsNestedImpl();
    }

    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item){
            return new SecretsNestedImpl(item);
    }

    public LocalObjectReference getSourceSecret(){
            return this.sourceSecret!=null?this.sourceSecret.build():null;
    }

    public A withSourceSecret(LocalObjectReference sourceSecret){
            if (sourceSecret!=null){ this.sourceSecret= new LocalObjectReferenceBuilder(sourceSecret); _visitables.add(this.sourceSecret);} return (A) this;
    }

    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret(){
            return new SourceSecretNestedImpl();
    }

    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item){
            return new SourceSecretNestedImpl(item);
    }

    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret(){
            return withNewSourceSecretLike(getSourceSecret());
    }

    public A withNewSourceSecret(String name){
            return (A)withSourceSecret(new LocalObjectReference(name));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildSourceFluentImpl that = (BuildSourceFluentImpl) o;
            if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
            if (contextDir != null ? !contextDir.equals(that.contextDir) :that.contextDir != null) return false;
            if (dockerfile != null ? !dockerfile.equals(that.dockerfile) :that.dockerfile != null) return false;
            if (git != null ? !git.equals(that.git) :that.git != null) return false;
            if (images != null ? !images.equals(that.images) :that.images != null) return false;
            if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
            if (sourceSecret != null ? !sourceSecret.equals(that.sourceSecret) :that.sourceSecret != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>> implements BuildSourceFluent.BinaryNested<N>,Nested<N>{

            private final BinaryBuildSourceBuilder builder;
    
            BinaryNestedImpl(){
                    this.builder = new BinaryBuildSourceBuilder(this);
            }
            BinaryNestedImpl(BinaryBuildSource item){
                    this.builder = new BinaryBuildSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSourceFluentImpl.this.withBinary(builder.build());
    }
    public N endBinary(){
            return and();
    }

}
    public class GitNestedImpl<N> extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>> implements BuildSourceFluent.GitNested<N>,Nested<N>{

            private final GitBuildSourceBuilder builder;
    
            GitNestedImpl(GitBuildSource item){
                    this.builder = new GitBuildSourceBuilder(this, item);
            }
            GitNestedImpl(){
                    this.builder = new GitBuildSourceBuilder(this);
            }
    
    public N and(){
            return (N) BuildSourceFluentImpl.this.withGit(builder.build());
    }
    public N endGit(){
            return and();
    }

}
    public class ImagesNestedImpl<N> extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>> implements BuildSourceFluent.ImagesNested<N>,Nested<N>{

            private final ImageSourceBuilder builder;
    
            ImagesNestedImpl(ImageSource item){
                    this.builder = new ImageSourceBuilder(this, item);
            }
            ImagesNestedImpl(){
                    this.builder = new ImageSourceBuilder(this);
            }
    
    public N and(){
            return (N) BuildSourceFluentImpl.this.addToImages(builder.build());
    }
    public N endImage(){
            return and();
    }

}
    public class SecretsNestedImpl<N> extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>> implements BuildSourceFluent.SecretsNested<N>,Nested<N>{

            private final SecretBuildSourceBuilder builder;
    
            SecretsNestedImpl(){
                    this.builder = new SecretBuildSourceBuilder(this);
            }
            SecretsNestedImpl(SecretBuildSource item){
                    this.builder = new SecretBuildSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSourceFluentImpl.this.addToSecrets(builder.build());
    }
    public N endSecret(){
            return and();
    }

}
    public class SourceSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>> implements BuildSourceFluent.SourceSecretNested<N>,Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            SourceSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
            SourceSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSourceFluentImpl.this.withSourceSecret(builder.build());
    }
    public N endSourceSecret(){
            return and();
    }

}


}
