package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecretListFluent<A extends SecretListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Secret... items);
    public A removeFromItems(Secret... items);
    public List<Secret> getItems();
    public A withItems(List<Secret> items);
    public A withItems(Secret... items);
    public SecretListFluent.ItemsNested<A> addNewItem();
    public SecretListFluent.ItemsNested<A> addNewItemLike(Secret item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public SecretListFluent.MetadataNested<A> withNewMetadata();
    public SecretListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public SecretListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,SecretFluent<SecretListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<SecretListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
