package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.LinkedHashMap;
import java.lang.Object;

public class ResourceRequirementsFluentImpl<A extends ResourceRequirementsFluent<A>> extends BaseFluent<A> implements ResourceRequirementsFluent<A>{

    private Map<String,Quantity> limits = new LinkedHashMap<String,Quantity>();
    private Map<String,Quantity> requests = new LinkedHashMap<String,Quantity>();

    public ResourceRequirementsFluentImpl(){
    }
    public ResourceRequirementsFluentImpl(ResourceRequirements instance){
            this.withLimits(instance.getLimits()); 
            this.withRequests(instance.getRequests()); 
    }

    public A addToLimits(String key,Quantity value){
            if(key != null && value != null) {this.limits.put(key, value);} return (A)this;
    }

    public A addToLimits(Map<String,Quantity> map){
            if(map != null) { this.limits.putAll(map);} return (A)this;
    }

    public A removeFromLimits(String key){
            if(key != null) {this.limits.remove(key);} return (A)this;
    }

    public A removeFromLimits(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.limits.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getLimits(){
            return this.limits;
    }

    public A withLimits(Map<String,Quantity> limits){
            this.limits.clear();
            if (limits != null) {this.limits.putAll(limits);} return (A) this;
    }

    public A addToRequests(String key,Quantity value){
            if(key != null && value != null) {this.requests.put(key, value);} return (A)this;
    }

    public A addToRequests(Map<String,Quantity> map){
            if(map != null) { this.requests.putAll(map);} return (A)this;
    }

    public A removeFromRequests(String key){
            if(key != null) {this.requests.remove(key);} return (A)this;
    }

    public A removeFromRequests(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.requests.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getRequests(){
            return this.requests;
    }

    public A withRequests(Map<String,Quantity> requests){
            this.requests.clear();
            if (requests != null) {this.requests.putAll(requests);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceRequirementsFluentImpl that = (ResourceRequirementsFluentImpl) o;
            if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
            if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
            return true;
    }




}
