package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class PersistentVolumeClaimSpecBuilder extends PersistentVolumeClaimSpecFluentImpl<PersistentVolumeClaimSpecBuilder> implements VisitableBuilder<PersistentVolumeClaimSpec,PersistentVolumeClaimSpecBuilder>{

    PersistentVolumeClaimSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentVolumeClaimSpecBuilder(){
            this(true);
    }
    public PersistentVolumeClaimSpecBuilder(Boolean validationEnabled){
            this(new PersistentVolumeClaimSpec(), validationEnabled);
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PersistentVolumeClaimSpec(), validationEnabled);
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,PersistentVolumeClaimSpec instance){
            this(fluent, instance, true);
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,PersistentVolumeClaimSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessModes(instance.getAccessModes()); 
            fluent.withResources(instance.getResources()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withVolumeName(instance.getVolumeName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpec instance){
            this(instance,true);
    }
    public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessModes(instance.getAccessModes()); 
            this.withResources(instance.getResources()); 
            this.withSelector(instance.getSelector()); 
            this.withVolumeName(instance.getVolumeName()); 
            this.validationEnabled = validationEnabled; 
    }

    public PersistentVolumeClaimSpec build(){
            PersistentVolumeClaimSpec buildable = new PersistentVolumeClaimSpec(fluent.getAccessModes(),fluent.getResources(),fluent.getSelector(),fluent.getVolumeName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeClaimSpecBuilder that = (PersistentVolumeClaimSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
