package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class LifecycleFluentImpl<A extends LifecycleFluent<A>> extends BaseFluent<A> implements LifecycleFluent<A>{

    private VisitableBuilder<? extends Handler,?> postStart;
    private VisitableBuilder<? extends Handler,?> preStop;

    public LifecycleFluentImpl(){
    }
    public LifecycleFluentImpl(Lifecycle instance){
            this.withPostStart(instance.getPostStart()); 
            this.withPreStop(instance.getPreStop()); 
    }

    public Handler getPostStart(){
            return this.postStart!=null?this.postStart.build():null;
    }

    public A withPostStart(Handler postStart){
            if (postStart!=null){ this.postStart= new HandlerBuilder(postStart); _visitables.add(this.postStart);} return (A) this;
    }

    public LifecycleFluent.PostStartNested<A> withNewPostStart(){
            return new PostStartNestedImpl();
    }

    public LifecycleFluent.PostStartNested<A> withNewPostStartLike(Handler item){
            return new PostStartNestedImpl(item);
    }

    public LifecycleFluent.PostStartNested<A> editPostStart(){
            return withNewPostStartLike(getPostStart());
    }

    public Handler getPreStop(){
            return this.preStop!=null?this.preStop.build():null;
    }

    public A withPreStop(Handler preStop){
            if (preStop!=null){ this.preStop= new HandlerBuilder(preStop); _visitables.add(this.preStop);} return (A) this;
    }

    public LifecycleFluent.PreStopNested<A> withNewPreStop(){
            return new PreStopNestedImpl();
    }

    public LifecycleFluent.PreStopNested<A> withNewPreStopLike(Handler item){
            return new PreStopNestedImpl(item);
    }

    public LifecycleFluent.PreStopNested<A> editPreStop(){
            return withNewPreStopLike(getPreStop());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LifecycleFluentImpl that = (LifecycleFluentImpl) o;
            if (postStart != null ? !postStart.equals(that.postStart) :that.postStart != null) return false;
            if (preStop != null ? !preStop.equals(that.preStop) :that.preStop != null) return false;
            return true;
    }


    public class PostStartNestedImpl<N> extends HandlerFluentImpl<LifecycleFluent.PostStartNested<N>> implements LifecycleFluent.PostStartNested<N>,Nested<N>{

            private final HandlerBuilder builder;
    
            PostStartNestedImpl(){
                    this.builder = new HandlerBuilder(this);
            }
            PostStartNestedImpl(Handler item){
                    this.builder = new HandlerBuilder(this, item);
            }
    
    public N endPostStart(){
            return and();
    }
    public N and(){
            return (N) LifecycleFluentImpl.this.withPostStart(builder.build());
    }

}
    public class PreStopNestedImpl<N> extends HandlerFluentImpl<LifecycleFluent.PreStopNested<N>> implements LifecycleFluent.PreStopNested<N>,Nested<N>{

            private final HandlerBuilder builder;
    
            PreStopNestedImpl(){
                    this.builder = new HandlerBuilder(this);
            }
            PreStopNestedImpl(Handler item){
                    this.builder = new HandlerBuilder(this, item);
            }
    
    public N and(){
            return (N) LifecycleFluentImpl.this.withPreStop(builder.build());
    }
    public N endPreStop(){
            return and();
    }

}


}
