package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EndpointsFluent<A extends EndpointsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public EndpointsFluent.MetadataNested<A> withNewMetadata();
    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EndpointsFluent.MetadataNested<A> editMetadata();
    public A addToSubsets(EndpointSubset... items);
    public A removeFromSubsets(EndpointSubset... items);
    public List<EndpointSubset> getSubsets();
    public A withSubsets(List<EndpointSubset> subsets);
    public A withSubsets(EndpointSubset... subsets);
    public EndpointsFluent.SubsetsNested<A> addNewSubset();
    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EndpointsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SubsetsNested<N> extends Nested<N>,EndpointSubsetFluent<EndpointsFluent.SubsetsNested<N>>{

        
    public N and();    public N endSubset();
}


}
