package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluent;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobBuilder;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleFluent;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.openshift.api.model.RoleFluent;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.UserFluent;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.GroupFluent;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.openshift.api.model.PolicyFluent;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluent;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.IdentityFluent;
import io.fabric8.openshift.api.model.IdentityBuilder;

public interface BaseKubernetesListFluent<A extends BaseKubernetesListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(HasMetadata... items);
    public A removeFromItems(HasMetadata... items);
    public List<HasMetadata> getItems();
    public A withItems(List<HasMetadata> items);
    public A withItems(HasMetadata... items);
    public A addToLimitRangeItems(LimitRange... items);
    public A removeFromLimitRangeItems(LimitRange... items);
    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem();
    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item);
    public A addToThirdPartyResourceItems(ThirdPartyResource... items);
    public A removeFromThirdPartyResourceItems(ThirdPartyResource... items);
    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItem();
    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItemLike(ThirdPartyResource item);
    public A addToJobItems(Job... items);
    public A removeFromJobItems(Job... items);
    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItem();
    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItemLike(Job item);
    public A addToProjectItems(Project... items);
    public A removeFromProjectItems(Project... items);
    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItem();
    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItemLike(Project item);
    public A addToSecurityContextConstraintsItems(SecurityContextConstraints... items);
    public A removeFromSecurityContextConstraintsItems(SecurityContextConstraints... items);
    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItem();
    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItemLike(SecurityContextConstraints item);
    public A addToBuildConfigItems(BuildConfig... items);
    public A removeFromBuildConfigItems(BuildConfig... items);
    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItem();
    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItemLike(BuildConfig item);
    public A addToRouteItems(Route... items);
    public A removeFromRouteItems(Route... items);
    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItem();
    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItemLike(Route item);
    public A addToOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items);
    public A removeFromOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items);
    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItem();
    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItemLike(OAuthAuthorizeToken item);
    public A addToNamespaceItems(Namespace... items);
    public A removeFromNamespaceItems(Namespace... items);
    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem();
    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item);
    public A addToClusterRoleBindingItems(ClusterRoleBinding... items);
    public A removeFromClusterRoleBindingItems(ClusterRoleBinding... items);
    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItem();
    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItemLike(ClusterRoleBinding item);
    public A addToServiceItems(Service... items);
    public A removeFromServiceItems(Service... items);
    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem();
    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item);
    public A addToReplicationControllerItems(ReplicationController... items);
    public A removeFromReplicationControllerItems(ReplicationController... items);
    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem();
    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item);
    public A addToProjectRequestItems(ProjectRequest... items);
    public A removeFromProjectRequestItems(ProjectRequest... items);
    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItem();
    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItemLike(ProjectRequest item);
    public A addToTemplateItems(Template... items);
    public A removeFromTemplateItems(Template... items);
    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItem();
    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItemLike(Template item);
    public A addToOAuthClientAuthorizationItems(OAuthClientAuthorization... items);
    public A removeFromOAuthClientAuthorizationItems(OAuthClientAuthorization... items);
    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItem();
    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItemLike(OAuthClientAuthorization item);
    public A addToPolicyBindingItems(PolicyBinding... items);
    public A removeFromPolicyBindingItems(PolicyBinding... items);
    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItem();
    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItemLike(PolicyBinding item);
    public A addToClusterRoleItems(ClusterRole... items);
    public A removeFromClusterRoleItems(ClusterRole... items);
    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItem();
    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItemLike(ClusterRole item);
    public A addToScaleItems(Scale... items);
    public A removeFromScaleItems(Scale... items);
    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItem();
    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItemLike(Scale item);
    public A addToPodTemplateItems(PodTemplate... items);
    public A removeFromPodTemplateItems(PodTemplate... items);
    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem();
    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item);
    public A addToEventItems(Event... items);
    public A removeFromEventItems(Event... items);
    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem();
    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item);
    public A addToIngressItems(Ingress... items);
    public A removeFromIngressItems(Ingress... items);
    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItem();
    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItemLike(Ingress item);
    public A addToDeploymentConfigItems(DeploymentConfig... items);
    public A removeFromDeploymentConfigItems(DeploymentConfig... items);
    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItem();
    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItemLike(DeploymentConfig item);
    public A addToOAuthAccessTokenItems(OAuthAccessToken... items);
    public A removeFromOAuthAccessTokenItems(OAuthAccessToken... items);
    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItem();
    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItemLike(OAuthAccessToken item);
    public A addToRoleBindingItems(RoleBinding... items);
    public A removeFromRoleBindingItems(RoleBinding... items);
    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItem();
    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItemLike(RoleBinding item);
    public A addToPersistentVolumeItems(PersistentVolume... items);
    public A removeFromPersistentVolumeItems(PersistentVolume... items);
    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem();
    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item);
    public A addToImageItems(Image... items);
    public A removeFromImageItems(Image... items);
    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItem();
    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItemLike(Image item);
    public A addToPersistentVolumeClaimItems(PersistentVolumeClaim... items);
    public A removeFromPersistentVolumeClaimItems(PersistentVolumeClaim... items);
    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem();
    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item);
    public A addToReplicaSetItems(ReplicaSet... items);
    public A removeFromReplicaSetItems(ReplicaSet... items);
    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItem();
    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItemLike(ReplicaSet item);
    public A addToRoleItems(Role... items);
    public A removeFromRoleItems(Role... items);
    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItem();
    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItemLike(Role item);
    public A addToEndpointsItems(Endpoints... items);
    public A removeFromEndpointsItems(Endpoints... items);
    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem();
    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item);
    public A addToPodItems(Pod... items);
    public A removeFromPodItems(Pod... items);
    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem();
    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item);
    public A addToConfigMapItems(ConfigMap... items);
    public A removeFromConfigMapItems(ConfigMap... items);
    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem();
    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item);
    public A addToClusterPolicyItems(ClusterPolicy... items);
    public A removeFromClusterPolicyItems(ClusterPolicy... items);
    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItem();
    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItemLike(ClusterPolicy item);
    public A addToDaemonSetItems(DaemonSet... items);
    public A removeFromDaemonSetItems(DaemonSet... items);
    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItem();
    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItemLike(DaemonSet item);
    public A addToDeploymentItems(Deployment... items);
    public A removeFromDeploymentItems(Deployment... items);
    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItem();
    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItemLike(Deployment item);
    public A addToUserItems(User... items);
    public A removeFromUserItems(User... items);
    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItem();
    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItemLike(User item);
    public A addToComponentStatusItems(ComponentStatus... items);
    public A removeFromComponentStatusItems(ComponentStatus... items);
    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem();
    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item);
    public A addToBuildItems(Build... items);
    public A removeFromBuildItems(Build... items);
    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItem();
    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItemLike(Build item);
    public A addToGroupItems(Group... items);
    public A removeFromGroupItems(Group... items);
    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItem();
    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItemLike(Group item);
    public A addToPolicyItems(Policy... items);
    public A removeFromPolicyItems(Policy... items);
    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItem();
    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItemLike(Policy item);
    public A addToImageSignatureItems(ImageSignature... items);
    public A removeFromImageSignatureItems(ImageSignature... items);
    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItem();
    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItemLike(ImageSignature item);
    public A addToBindingItems(Binding... items);
    public A removeFromBindingItems(Binding... items);
    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem();
    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item);
    public A addToResourceQuotaItems(ResourceQuota... items);
    public A removeFromResourceQuotaItems(ResourceQuota... items);
    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem();
    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item);
    public A addToSecretItems(Secret... items);
    public A removeFromSecretItems(Secret... items);
    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem();
    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item);
    public A addToBuildRequestItems(BuildRequest... items);
    public A removeFromBuildRequestItems(BuildRequest... items);
    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItem();
    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItemLike(BuildRequest item);
    public A addToClusterPolicyBindingItems(ClusterPolicyBinding... items);
    public A removeFromClusterPolicyBindingItems(ClusterPolicyBinding... items);
    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItem();
    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItemLike(ClusterPolicyBinding item);
    public A addToNodeItems(Node... items);
    public A removeFromNodeItems(Node... items);
    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem();
    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item);
    public A addToImageStreamItems(ImageStream... items);
    public A removeFromImageStreamItems(ImageStream... items);
    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItem();
    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItemLike(ImageStream item);
    public A addToHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items);
    public A removeFromHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items);
    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItem();
    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItemLike(HorizontalPodAutoscaler item);
    public A addToOAuthClientItems(OAuthClient... items);
    public A removeFromOAuthClientItems(OAuthClient... items);
    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItem();
    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItemLike(OAuthClient item);
    public A addToServiceAccountItems(ServiceAccount... items);
    public A removeFromServiceAccountItems(ServiceAccount... items);
    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem();
    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item);
    public A addToIdentityItems(Identity... items);
    public A removeFromIdentityItems(Identity... items);
    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItem();
    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItemLike(Identity item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata();
    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public BaseKubernetesListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface LimitRangeItemsNested<N> extends Nested<N>,LimitRangeFluent<BaseKubernetesListFluent.LimitRangeItemsNested<N>>{

        
    public N endLimitRangeItem();    public N and();
}
    public interface ThirdPartyResourceItemsNested<N> extends Nested<N>,ThirdPartyResourceFluent<BaseKubernetesListFluent.ThirdPartyResourceItemsNested<N>>{

        
    public N endThirdPartyResourceItem();    public N and();
}
    public interface JobItemsNested<N> extends Nested<N>,JobFluent<BaseKubernetesListFluent.JobItemsNested<N>>{

        
    public N and();    public N endJobItem();
}
    public interface ProjectItemsNested<N> extends Nested<N>,ProjectFluent<BaseKubernetesListFluent.ProjectItemsNested<N>>{

        
    public N endProjectItem();    public N and();
}
    public interface SecurityContextConstraintsItemsNested<N> extends Nested<N>,SecurityContextConstraintsFluent<BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<N>>{

        
    public N and();    public N endSecurityContextConstraintsItem();
}
    public interface BuildConfigItemsNested<N> extends Nested<N>,BuildConfigFluent<BaseKubernetesListFluent.BuildConfigItemsNested<N>>{

        
    public N and();    public N endBuildConfigItem();
}
    public interface RouteItemsNested<N> extends Nested<N>,RouteFluent<BaseKubernetesListFluent.RouteItemsNested<N>>{

        
    public N and();    public N endRouteItem();
}
    public interface OAuthAuthorizeTokenItemsNested<N> extends Nested<N>,OAuthAuthorizeTokenFluent<BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<N>>{

        
    public N and();    public N endOAuthAuthorizeTokenItem();
}
    public interface NamespaceItemsNested<N> extends Nested<N>,NamespaceFluent<BaseKubernetesListFluent.NamespaceItemsNested<N>>{

        
    public N endNamespaceItem();    public N and();
}
    public interface ClusterRoleBindingItemsNested<N> extends Nested<N>,ClusterRoleBindingFluent<BaseKubernetesListFluent.ClusterRoleBindingItemsNested<N>>{

        
    public N endClusterRoleBindingItem();    public N and();
}
    public interface ServiceItemsNested<N> extends Nested<N>,ServiceFluent<BaseKubernetesListFluent.ServiceItemsNested<N>>{

        
    public N endServiceItem();    public N and();
}
    public interface ReplicationControllerItemsNested<N> extends Nested<N>,ReplicationControllerFluent<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>>{

        
    public N endReplicationControllerItem();    public N and();
}
    public interface ProjectRequestItemsNested<N> extends Nested<N>,ProjectRequestFluent<BaseKubernetesListFluent.ProjectRequestItemsNested<N>>{

        
    public N endProjectRequestItem();    public N and();
}
    public interface TemplateItemsNested<N> extends Nested<N>,TemplateFluent<BaseKubernetesListFluent.TemplateItemsNested<N>>{

        
    public N and();    public N endTemplateItem();
}
    public interface OAuthClientAuthorizationItemsNested<N> extends Nested<N>,OAuthClientAuthorizationFluent<BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<N>>{

        
    public N and();    public N endOAuthClientAuthorizationItem();
}
    public interface PolicyBindingItemsNested<N> extends Nested<N>,PolicyBindingFluent<BaseKubernetesListFluent.PolicyBindingItemsNested<N>>{

        
    public N endPolicyBindingItem();    public N and();
}
    public interface ClusterRoleItemsNested<N> extends Nested<N>,ClusterRoleFluent<BaseKubernetesListFluent.ClusterRoleItemsNested<N>>{

        
    public N endClusterRoleItem();    public N and();
}
    public interface ScaleItemsNested<N> extends Nested<N>,ScaleFluent<BaseKubernetesListFluent.ScaleItemsNested<N>>{

        
    public N endScaleItem();    public N and();
}
    public interface PodTemplateItemsNested<N> extends Nested<N>,PodTemplateFluent<BaseKubernetesListFluent.PodTemplateItemsNested<N>>{

        
    public N endPodTemplateItem();    public N and();
}
    public interface EventItemsNested<N> extends Nested<N>,EventFluent<BaseKubernetesListFluent.EventItemsNested<N>>{

        
    public N and();    public N endEventItem();
}
    public interface IngressItemsNested<N> extends Nested<N>,IngressFluent<BaseKubernetesListFluent.IngressItemsNested<N>>{

        
    public N and();    public N endIngressItem();
}
    public interface DeploymentConfigItemsNested<N> extends Nested<N>,DeploymentConfigFluent<BaseKubernetesListFluent.DeploymentConfigItemsNested<N>>{

        
    public N and();    public N endDeploymentConfigItem();
}
    public interface OAuthAccessTokenItemsNested<N> extends Nested<N>,OAuthAccessTokenFluent<BaseKubernetesListFluent.OAuthAccessTokenItemsNested<N>>{

        
    public N and();    public N endOAuthAccessTokenItem();
}
    public interface RoleBindingItemsNested<N> extends Nested<N>,RoleBindingFluent<BaseKubernetesListFluent.RoleBindingItemsNested<N>>{

        
    public N endRoleBindingItem();    public N and();
}
    public interface PersistentVolumeItemsNested<N> extends Nested<N>,PersistentVolumeFluent<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>>{

        
    public N endPersistentVolumeItem();    public N and();
}
    public interface ImageItemsNested<N> extends Nested<N>,ImageFluent<BaseKubernetesListFluent.ImageItemsNested<N>>{

        
    public N and();    public N endImageItem();
}
    public interface PersistentVolumeClaimItemsNested<N> extends Nested<N>,PersistentVolumeClaimFluent<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>>{

        
    public N endPersistentVolumeClaimItem();    public N and();
}
    public interface ReplicaSetItemsNested<N> extends Nested<N>,ReplicaSetFluent<BaseKubernetesListFluent.ReplicaSetItemsNested<N>>{

        
    public N endReplicaSetItem();    public N and();
}
    public interface RoleItemsNested<N> extends Nested<N>,RoleFluent<BaseKubernetesListFluent.RoleItemsNested<N>>{

        
    public N endRoleItem();    public N and();
}
    public interface EndpointsItemsNested<N> extends Nested<N>,EndpointsFluent<BaseKubernetesListFluent.EndpointsItemsNested<N>>{

        
    public N and();    public N endEndpointsItem();
}
    public interface PodItemsNested<N> extends Nested<N>,PodFluent<BaseKubernetesListFluent.PodItemsNested<N>>{

        
    public N endPodItem();    public N and();
}
    public interface ConfigMapItemsNested<N> extends Nested<N>,ConfigMapFluent<BaseKubernetesListFluent.ConfigMapItemsNested<N>>{

        
    public N and();    public N endConfigMapItem();
}
    public interface ClusterPolicyItemsNested<N> extends Nested<N>,ClusterPolicyFluent<BaseKubernetesListFluent.ClusterPolicyItemsNested<N>>{

        
    public N endClusterPolicyItem();    public N and();
}
    public interface DaemonSetItemsNested<N> extends Nested<N>,DaemonSetFluent<BaseKubernetesListFluent.DaemonSetItemsNested<N>>{

        
    public N and();    public N endDaemonSetItem();
}
    public interface DeploymentItemsNested<N> extends Nested<N>,DeploymentFluent<BaseKubernetesListFluent.DeploymentItemsNested<N>>{

        
    public N endDeploymentItem();    public N and();
}
    public interface UserItemsNested<N> extends Nested<N>,UserFluent<BaseKubernetesListFluent.UserItemsNested<N>>{

        
    public N and();    public N endUserItem();
}
    public interface ComponentStatusItemsNested<N> extends Nested<N>,ComponentStatusFluent<BaseKubernetesListFluent.ComponentStatusItemsNested<N>>{

        
    public N endComponentStatusItem();    public N and();
}
    public interface BuildItemsNested<N> extends Nested<N>,BuildFluent<BaseKubernetesListFluent.BuildItemsNested<N>>{

        
    public N endBuildItem();    public N and();
}
    public interface GroupItemsNested<N> extends Nested<N>,GroupFluent<BaseKubernetesListFluent.GroupItemsNested<N>>{

        
    public N endGroupItem();    public N and();
}
    public interface PolicyItemsNested<N> extends Nested<N>,PolicyFluent<BaseKubernetesListFluent.PolicyItemsNested<N>>{

        
    public N and();    public N endPolicyItem();
}
    public interface ImageSignatureItemsNested<N> extends Nested<N>,ImageSignatureFluent<BaseKubernetesListFluent.ImageSignatureItemsNested<N>>{

        
    public N endImageSignatureItem();    public N and();
}
    public interface BindingItemsNested<N> extends Nested<N>,BindingFluent<BaseKubernetesListFluent.BindingItemsNested<N>>{

        
    public N endBindingItem();    public N and();
}
    public interface ResourceQuotaItemsNested<N> extends Nested<N>,ResourceQuotaFluent<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>>{

        
    public N and();    public N endResourceQuotaItem();
}
    public interface SecretItemsNested<N> extends Nested<N>,SecretFluent<BaseKubernetesListFluent.SecretItemsNested<N>>{

        
    public N endSecretItem();    public N and();
}
    public interface BuildRequestItemsNested<N> extends Nested<N>,BuildRequestFluent<BaseKubernetesListFluent.BuildRequestItemsNested<N>>{

        
    public N endBuildRequestItem();    public N and();
}
    public interface ClusterPolicyBindingItemsNested<N> extends Nested<N>,ClusterPolicyBindingFluent<BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<N>>{

        
    public N endClusterPolicyBindingItem();    public N and();
}
    public interface NodeItemsNested<N> extends Nested<N>,NodeFluent<BaseKubernetesListFluent.NodeItemsNested<N>>{

        
    public N and();    public N endNodeItem();
}
    public interface ImageStreamItemsNested<N> extends Nested<N>,ImageStreamFluent<BaseKubernetesListFluent.ImageStreamItemsNested<N>>{

        
    public N and();    public N endImageStreamItem();
}
    public interface HorizontalPodAutoscalerItemsNested<N> extends Nested<N>,HorizontalPodAutoscalerFluent<BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<N>>{

        
    public N endHorizontalPodAutoscalerItem();    public N and();
}
    public interface OAuthClientItemsNested<N> extends Nested<N>,OAuthClientFluent<BaseKubernetesListFluent.OAuthClientItemsNested<N>>{

        
    public N and();    public N endOAuthClientItem();
}
    public interface ServiceAccountItemsNested<N> extends Nested<N>,ServiceAccountFluent<BaseKubernetesListFluent.ServiceAccountItemsNested<N>>{

        
    public N endServiceAccountItem();    public N and();
}
    public interface IdentityItemsNested<N> extends Nested<N>,IdentityFluent<BaseKubernetesListFluent.IdentityItemsNested<N>>{

        
    public N endIdentityItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<BaseKubernetesListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
