package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.IntOrString;
import javax.validation.Valid;
import java.lang.Integer;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface RollingDeploymentStrategyParamsFluent<A extends RollingDeploymentStrategyParamsFluent<A>> extends Fluent<A>{


    public Long getIntervalSeconds();
    public A withIntervalSeconds(Long intervalSeconds);
    public IntOrString getMaxSurge();
    public A withMaxSurge(IntOrString maxSurge);
    public RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> withNewMaxSurge();
    public RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> withNewMaxSurgeLike(IntOrString item);
    public RollingDeploymentStrategyParamsFluent.MaxSurgeNested<A> editMaxSurge();
    public A withNewMaxSurge(String strVal);
    public A withNewMaxSurge(Integer intVal);
    public IntOrString getMaxUnavailable();
    public A withMaxUnavailable(IntOrString maxUnavailable);
    public RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> withNewMaxUnavailable();
    public RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item);
    public RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<A> editMaxUnavailable();
    public A withNewMaxUnavailable(String strVal);
    public A withNewMaxUnavailable(Integer intVal);
    public LifecycleHook getPost();
    public A withPost(LifecycleHook post);
    public RollingDeploymentStrategyParamsFluent.PostNested<A> withNewPost();
    public RollingDeploymentStrategyParamsFluent.PostNested<A> withNewPostLike(LifecycleHook item);
    public RollingDeploymentStrategyParamsFluent.PostNested<A> editPost();
    public LifecycleHook getPre();
    public A withPre(LifecycleHook pre);
    public RollingDeploymentStrategyParamsFluent.PreNested<A> withNewPre();
    public RollingDeploymentStrategyParamsFluent.PreNested<A> withNewPreLike(LifecycleHook item);
    public RollingDeploymentStrategyParamsFluent.PreNested<A> editPre();
    public Long getTimeoutSeconds();
    public A withTimeoutSeconds(Long timeoutSeconds);
    public Integer getUpdatePercent();
    public A withUpdatePercent(Integer updatePercent);
    public Long getUpdatePeriodSeconds();
    public A withUpdatePeriodSeconds(Long updatePeriodSeconds);

    public interface MaxSurgeNested<N> extends Nested<N>,IntOrStringFluent<RollingDeploymentStrategyParamsFluent.MaxSurgeNested<N>>{

        
    public N and();    public N endMaxSurge();
}
    public interface MaxUnavailableNested<N> extends Nested<N>,IntOrStringFluent<RollingDeploymentStrategyParamsFluent.MaxUnavailableNested<N>>{

        
    public N endMaxUnavailable();    public N and();
}
    public interface PostNested<N> extends Nested<N>,LifecycleHookFluent<RollingDeploymentStrategyParamsFluent.PostNested<N>>{

        
    public N endPost();    public N and();
}
    public interface PreNested<N> extends Nested<N>,LifecycleHookFluent<RollingDeploymentStrategyParamsFluent.PreNested<N>>{

        
    public N and();    public N endPre();
}


}
