package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface RoleFluent<A extends RoleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public RoleFluent.MetadataNested<A> withNewMetadata();
    public RoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RoleFluent.MetadataNested<A> editMetadata();
    public A addToRules(PolicyRule... items);
    public A removeFromRules(PolicyRule... items);
    public List<PolicyRule> getRules();
    public A withRules(List<PolicyRule> rules);
    public A withRules(PolicyRule... rules);
    public RoleFluent.RulesNested<A> addNewRule();
    public RoleFluent.RulesNested<A> addNewRuleLike(PolicyRule item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RoleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RulesNested<N> extends Nested<N>,PolicyRuleFluent<RoleFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}


}
