package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends Fluent<A>{


    public A addToAdditionalSecrets(String... items);
    public A removeFromAdditionalSecrets(String... items);
    public List<String> getAdditionalSecrets();
    public A withAdditionalSecrets(List<String> additionalSecrets);
    public A withAdditionalSecrets(String... additionalSecrets);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public OAuthClientFluent.MetadataNested<A> withNewMetadata();
    public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthClientFluent.MetadataNested<A> editMetadata();
    public A addToRedirectURIs(String... items);
    public A removeFromRedirectURIs(String... items);
    public List<String> getRedirectURIs();
    public A withRedirectURIs(List<String> redirectURIs);
    public A withRedirectURIs(String... redirectURIs);
    public Boolean isRespondWithChallenges();
    public A withRespondWithChallenges(Boolean respondWithChallenges);
    public A addToScopeRestrictions(ScopeRestriction... items);
    public A removeFromScopeRestrictions(ScopeRestriction... items);
    public List<ScopeRestriction> getScopeRestrictions();
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions);
    public A withScopeRestrictions(ScopeRestriction... scopeRestrictions);
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction();
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item);
    public String getSecret();
    public A withSecret(String secret);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthClientFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface ScopeRestrictionsNested<N> extends Nested<N>,ScopeRestrictionFluent<OAuthClientFluent.ScopeRestrictionsNested<N>>{

        
    public N endScopeRestriction();    public N and();
}


}
