package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedClusterRoleBindingFluent<A extends NamedClusterRoleBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public ClusterRoleBinding getRoleBinding();
    public A withRoleBinding(ClusterRoleBinding roleBinding);
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding();
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(ClusterRoleBinding item);
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editRoleBinding();

    public interface RoleBindingNested<N> extends Nested<N>,ClusterRoleBindingFluent<NamedClusterRoleBindingFluent.RoleBindingNested<N>>{

        
    public N endRoleBinding();    public N and();
}


}
