
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "details",
    "latestVersion",
    "observedGeneration"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class DeploymentConfigStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("details")
    @Valid
    private DeploymentDetails details;
    /**
     * 
     * 
     */
    @JsonProperty("latestVersion")
    private Integer latestVersion;
    /**
     * 
     * 
     */
    @JsonProperty("observedGeneration")
    private Long observedGeneration;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DeploymentConfigStatus() {
    }

    /**
     * 
     * @param latestVersion
     * @param details
     * @param observedGeneration
     */
    public DeploymentConfigStatus(DeploymentDetails details, Integer latestVersion, Long observedGeneration) {
        this.details = details;
        this.latestVersion = latestVersion;
        this.observedGeneration = observedGeneration;
    }

    /**
     * 
     * 
     * @return
     *     The details
     */
    @JsonProperty("details")
    public DeploymentDetails getDetails() {
        return details;
    }

    /**
     * 
     * 
     * @param details
     *     The details
     */
    @JsonProperty("details")
    public void setDetails(DeploymentDetails details) {
        this.details = details;
    }

    /**
     * 
     * 
     * @return
     *     The latestVersion
     */
    @JsonProperty("latestVersion")
    public Integer getLatestVersion() {
        return latestVersion;
    }

    /**
     * 
     * 
     * @param latestVersion
     *     The latestVersion
     */
    @JsonProperty("latestVersion")
    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    /**
     * 
     * 
     * @return
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    /**
     * 
     * 
     * @param observedGeneration
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
