package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.IntOrString;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

public interface IngressBackendFluent<A extends IngressBackendFluent<A>> extends Fluent<A>{


    public String getServiceName();
    public A withServiceName(String serviceName);
    public IntOrString getServicePort();
    public A withServicePort(IntOrString servicePort);
    public IngressBackendFluent.ServicePortNested<A> withNewServicePort();
    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item);
    public IngressBackendFluent.ServicePortNested<A> editServicePort();
    public A withNewServicePort(String strVal);
    public A withNewServicePort(Integer intVal);

    public interface ServicePortNested<N> extends Nested<N>,IntOrStringFluent<IngressBackendFluent.ServicePortNested<N>>{

        
    public N and();    public N endServicePort();
}


}
