package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class PodTemplateSpecFluentImpl<A extends PodTemplateSpecFluent<A>> extends BaseFluent<A> implements PodTemplateSpecFluent<A>{

    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private VisitableBuilder<? extends PodSpec,?> spec;

    public PodTemplateSpecFluentImpl(){
    }
    public PodTemplateSpecFluentImpl(PodTemplateSpec instance){
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public PodTemplateSpecFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PodSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(PodSpec spec){
            if (spec!=null){ this.spec= new PodSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public PodTemplateSpecFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public PodTemplateSpecFluent.SpecNested<A> withNewSpecLike(PodSpec item){
            return new SpecNestedImpl(item);
    }

    public PodTemplateSpecFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodTemplateSpecFluentImpl that = (PodTemplateSpecFluentImpl) o;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PodTemplateSpecFluent.MetadataNested<N>> implements PodTemplateSpecFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) PodTemplateSpecFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends PodSpecFluentImpl<PodTemplateSpecFluent.SpecNested<N>> implements PodTemplateSpecFluent.SpecNested<N>,Nested<N>{

            private final PodSpecBuilder builder;
    
            SpecNestedImpl(){
                    this.builder = new PodSpecBuilder(this);
            }
            SpecNestedImpl(PodSpec item){
                    this.builder = new PodSpecBuilder(this, item);
            }
    
    public N endSpec(){
            return and();
    }
    public N and(){
            return (N) PodTemplateSpecFluentImpl.this.withSpec(builder.build());
    }

}


}
