package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class NodeStatusBuilder extends NodeStatusFluentImpl<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{

    NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NodeStatusBuilder(){
            this(true);
    }
    public NodeStatusBuilder(Boolean validationEnabled){
            this(new NodeStatus(), validationEnabled);
    }
    public NodeStatusBuilder(NodeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public NodeStatusBuilder(NodeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NodeStatus(), validationEnabled);
    }
    public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance){
            this(fluent, instance, true);
    }
    public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddresses(instance.getAddresses()); 
            fluent.withAllocatable(instance.getAllocatable()); 
            fluent.withCapacity(instance.getCapacity()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withDaemonEndpoints(instance.getDaemonEndpoints()); 
            fluent.withImages(instance.getImages()); 
            fluent.withNodeInfo(instance.getNodeInfo()); 
            fluent.withPhase(instance.getPhase()); 
            this.validationEnabled = validationEnabled; 
    }
    public NodeStatusBuilder(NodeStatus instance){
            this(instance,true);
    }
    public NodeStatusBuilder(NodeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddresses(instance.getAddresses()); 
            this.withAllocatable(instance.getAllocatable()); 
            this.withCapacity(instance.getCapacity()); 
            this.withConditions(instance.getConditions()); 
            this.withDaemonEndpoints(instance.getDaemonEndpoints()); 
            this.withImages(instance.getImages()); 
            this.withNodeInfo(instance.getNodeInfo()); 
            this.withPhase(instance.getPhase()); 
            this.validationEnabled = validationEnabled; 
    }

    public NodeStatus build(){
            NodeStatus buildable = new NodeStatus(fluent.getAddresses(),fluent.getAllocatable(),fluent.getCapacity(),fluent.getConditions(),fluent.getDaemonEndpoints(),fluent.getImages(),fluent.getNodeInfo(),fluent.getPhase());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeStatusBuilder that = (NodeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
