package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ProjectRequestFluent<A extends ProjectRequestFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getDescription();
    public A withDescription(String description);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ProjectRequestFluent.MetadataNested<A> withNewMetadata();
    public ProjectRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ProjectRequestFluent.MetadataNested<A> editMetadata();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ProjectRequestFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
