package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface PolicyFluent<A extends PolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public String getLastModified();
    public A withLastModified(String lastModified);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PolicyFluent.MetadataNested<A> withNewMetadata();
    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyFluent.MetadataNested<A> editMetadata();
    public A addToRoles(NamedRole... items);
    public A removeFromRoles(NamedRole... items);
    public List<NamedRole> getRoles();
    public A withRoles(List<NamedRole> roles);
    public A withRoles(NamedRole... roles);
    public PolicyFluent.RolesNested<A> addNewRole();
    public PolicyFluent.RolesNested<A> addNewRoleLike(NamedRole item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RolesNested<N> extends Nested<N>,NamedRoleFluent<PolicyFluent.RolesNested<N>>{

        
    public N endRole();    public N and();
}


}
