package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class GitSourceRevisionFluentImpl<A extends GitSourceRevisionFluent<A>> extends BaseFluent<A> implements GitSourceRevisionFluent<A>{

    private VisitableBuilder<? extends SourceControlUser,?> author;
    private String commit;
    private VisitableBuilder<? extends SourceControlUser,?> committer;
    private String message;

    public GitSourceRevisionFluentImpl(){
    }
    public GitSourceRevisionFluentImpl(GitSourceRevision instance){
            this.withAuthor(instance.getAuthor()); 
            this.withCommit(instance.getCommit()); 
            this.withCommitter(instance.getCommitter()); 
            this.withMessage(instance.getMessage()); 
    }

    public SourceControlUser getAuthor(){
            return this.author!=null?this.author.build():null;
    }

    public A withAuthor(SourceControlUser author){
            if (author!=null){ this.author= new SourceControlUserBuilder(author); _visitables.add(this.author);} return (A) this;
    }

    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthor(){
            return new AuthorNestedImpl();
    }

    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthorLike(SourceControlUser item){
            return new AuthorNestedImpl(item);
    }

    public GitSourceRevisionFluent.AuthorNested<A> editAuthor(){
            return withNewAuthorLike(getAuthor());
    }

    public A withNewAuthor(String email,String name){
            return (A)withAuthor(new SourceControlUser(email, name));
    }

    public String getCommit(){
            return this.commit;
    }

    public A withCommit(String commit){
            this.commit=commit; return (A) this;
    }

    public SourceControlUser getCommitter(){
            return this.committer!=null?this.committer.build():null;
    }

    public A withCommitter(SourceControlUser committer){
            if (committer!=null){ this.committer= new SourceControlUserBuilder(committer); _visitables.add(this.committer);} return (A) this;
    }

    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitter(){
            return new CommitterNestedImpl();
    }

    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitterLike(SourceControlUser item){
            return new CommitterNestedImpl(item);
    }

    public GitSourceRevisionFluent.CommitterNested<A> editCommitter(){
            return withNewCommitterLike(getCommitter());
    }

    public A withNewCommitter(String email,String name){
            return (A)withCommitter(new SourceControlUser(email, name));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl) o;
            if (author != null ? !author.equals(that.author) :that.author != null) return false;
            if (commit != null ? !commit.equals(that.commit) :that.commit != null) return false;
            if (committer != null ? !committer.equals(that.committer) :that.committer != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            return true;
    }


    public class AuthorNestedImpl<N> extends SourceControlUserFluentImpl<GitSourceRevisionFluent.AuthorNested<N>> implements GitSourceRevisionFluent.AuthorNested<N>,Nested<N>{

            private final SourceControlUserBuilder builder;
    
            AuthorNestedImpl(){
                    this.builder = new SourceControlUserBuilder(this);
            }
            AuthorNestedImpl(SourceControlUser item){
                    this.builder = new SourceControlUserBuilder(this, item);
            }
    
    public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withAuthor(builder.build());
    }
    public N endAuthor(){
            return and();
    }

}
    public class CommitterNestedImpl<N> extends SourceControlUserFluentImpl<GitSourceRevisionFluent.CommitterNested<N>> implements GitSourceRevisionFluent.CommitterNested<N>,Nested<N>{

            private final SourceControlUserBuilder builder;
    
            CommitterNestedImpl(){
                    this.builder = new SourceControlUserBuilder(this);
            }
            CommitterNestedImpl(SourceControlUser item){
                    this.builder = new SourceControlUserBuilder(this, item);
            }
    
    public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withCommitter(builder.build());
    }
    public N endCommitter(){
            return and();
    }

}


}
