package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class BuildTriggerPolicyBuilder extends BuildTriggerPolicyFluentImpl<BuildTriggerPolicyBuilder> implements VisitableBuilder<BuildTriggerPolicy,BuildTriggerPolicyBuilder>{

    BuildTriggerPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public BuildTriggerPolicyBuilder(){
            this(true);
    }
    public BuildTriggerPolicyBuilder(Boolean validationEnabled){
            this(new BuildTriggerPolicy(), validationEnabled);
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildTriggerPolicy(), validationEnabled);
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,BuildTriggerPolicy instance){
            this(fluent, instance, true);
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent,BuildTriggerPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGeneric(instance.getGeneric()); 
            fluent.withGithub(instance.getGithub()); 
            fluent.withImageChange(instance.getImageChange()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance){
            this(instance,true);
    }
    public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGeneric(instance.getGeneric()); 
            this.withGithub(instance.getGithub()); 
            this.withImageChange(instance.getImageChange()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildTriggerPolicy build(){
            BuildTriggerPolicy buildable = new BuildTriggerPolicy(fluent.getGeneric(),fluent.getGithub(),fluent.getImageChange(),fluent.getType());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildTriggerPolicyBuilder that = (BuildTriggerPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
