package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeListFluent<A extends PersistentVolumeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PersistentVolume... items);
    public A removeFromItems(PersistentVolume... items);
    public List<PersistentVolume> getItems();
    public A withItems(List<PersistentVolume> items);
    public A withItems(PersistentVolume... items);
    public PersistentVolumeListFluent.ItemsNested<A> addNewItem();
    public PersistentVolumeListFluent.ItemsNested<A> addNewItemLike(PersistentVolume item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PersistentVolumeListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PersistentVolumeFluent<PersistentVolumeListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PersistentVolumeListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
