package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface UserListFluent<A extends UserListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(User... items);
    public A removeFromItems(User... items);
    public List<User> getItems();
    public A withItems(List<User> items);
    public A withItems(User... items);
    public UserListFluent.ItemsNested<A> addNewItem();
    public UserListFluent.ItemsNested<A> addNewItemLike(User item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public UserListFluent.MetadataNested<A> withNewMetadata();
    public UserListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public UserListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,UserFluent<UserListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<UserListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
