package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedRoleFluentImpl<A extends NamedRoleFluent<A>> extends BaseFluent<A> implements NamedRoleFluent<A>{

    private String name;
    private VisitableBuilder<? extends Role,?> role;

    public NamedRoleFluentImpl(){
    }
    public NamedRoleFluentImpl(NamedRole instance){
            this.withName(instance.getName()); 
            this.withRole(instance.getRole()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Role getRole(){
            return this.role!=null?this.role.build():null;
    }

    public A withRole(Role role){
            if (role!=null){ this.role= new RoleBuilder(role); _visitables.add(this.role);} return (A) this;
    }

    public NamedRoleFluent.RoleNested<A> withNewRole(){
            return new RoleNestedImpl();
    }

    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item){
            return new RoleNestedImpl(item);
    }

    public NamedRoleFluent.RoleNested<A> editRole(){
            return withNewRoleLike(getRole());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedRoleFluentImpl that = (NamedRoleFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (role != null ? !role.equals(that.role) :that.role != null) return false;
            return true;
    }


    public class RoleNestedImpl<N> extends RoleFluentImpl<NamedRoleFluent.RoleNested<N>> implements NamedRoleFluent.RoleNested<N>,Nested<N>{

            private final RoleBuilder builder;
    
            RoleNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
            RoleNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
    
    public N endRole(){
            return and();
    }
    public N and(){
            return (N) NamedRoleFluentImpl.this.withRole(builder.build());
    }

}


}
