package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class BuildTriggerPolicyFluentImpl<A extends BuildTriggerPolicyFluent<A>> extends BaseFluent<A> implements BuildTriggerPolicyFluent<A>{

    private VisitableBuilder<? extends WebHookTrigger,?> generic;
    private VisitableBuilder<? extends WebHookTrigger,?> github;
    private VisitableBuilder<? extends ImageChangeTrigger,?> imageChange;
    private String type;

    public BuildTriggerPolicyFluentImpl(){
    }
    public BuildTriggerPolicyFluentImpl(BuildTriggerPolicy instance){
            this.withGeneric(instance.getGeneric()); 
            this.withGithub(instance.getGithub()); 
            this.withImageChange(instance.getImageChange()); 
            this.withType(instance.getType()); 
    }

    public WebHookTrigger getGeneric(){
            return this.generic!=null?this.generic.build():null;
    }

    public A withGeneric(WebHookTrigger generic){
            if (generic!=null){ this.generic= new WebHookTriggerBuilder(generic); _visitables.add(this.generic);} return (A) this;
    }

    public BuildTriggerPolicyFluent.GenericNested<A> withNewGeneric(){
            return new GenericNestedImpl();
    }

    public BuildTriggerPolicyFluent.GenericNested<A> withNewGenericLike(WebHookTrigger item){
            return new GenericNestedImpl(item);
    }

    public BuildTriggerPolicyFluent.GenericNested<A> editGeneric(){
            return withNewGenericLike(getGeneric());
    }

    public A withNewGeneric(Boolean allowEnv,String secret){
            return (A)withGeneric(new WebHookTrigger(allowEnv, secret));
    }

    public WebHookTrigger getGithub(){
            return this.github!=null?this.github.build():null;
    }

    public A withGithub(WebHookTrigger github){
            if (github!=null){ this.github= new WebHookTriggerBuilder(github); _visitables.add(this.github);} return (A) this;
    }

    public BuildTriggerPolicyFluent.GithubNested<A> withNewGithub(){
            return new GithubNestedImpl();
    }

    public BuildTriggerPolicyFluent.GithubNested<A> withNewGithubLike(WebHookTrigger item){
            return new GithubNestedImpl(item);
    }

    public BuildTriggerPolicyFluent.GithubNested<A> editGithub(){
            return withNewGithubLike(getGithub());
    }

    public A withNewGithub(Boolean allowEnv,String secret){
            return (A)withGithub(new WebHookTrigger(allowEnv, secret));
    }

    public ImageChangeTrigger getImageChange(){
            return this.imageChange!=null?this.imageChange.build():null;
    }

    public A withImageChange(ImageChangeTrigger imageChange){
            if (imageChange!=null){ this.imageChange= new ImageChangeTriggerBuilder(imageChange); _visitables.add(this.imageChange);} return (A) this;
    }

    public BuildTriggerPolicyFluent.ImageChangeNested<A> withNewImageChange(){
            return new ImageChangeNestedImpl();
    }

    public BuildTriggerPolicyFluent.ImageChangeNested<A> withNewImageChangeLike(ImageChangeTrigger item){
            return new ImageChangeNestedImpl(item);
    }

    public BuildTriggerPolicyFluent.ImageChangeNested<A> editImageChange(){
            return withNewImageChangeLike(getImageChange());
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildTriggerPolicyFluentImpl that = (BuildTriggerPolicyFluentImpl) o;
            if (generic != null ? !generic.equals(that.generic) :that.generic != null) return false;
            if (github != null ? !github.equals(that.github) :that.github != null) return false;
            if (imageChange != null ? !imageChange.equals(that.imageChange) :that.imageChange != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class GenericNestedImpl<N> extends WebHookTriggerFluentImpl<BuildTriggerPolicyFluent.GenericNested<N>> implements BuildTriggerPolicyFluent.GenericNested<N>,Nested<N>{

            private final WebHookTriggerBuilder builder;
    
            GenericNestedImpl(){
                    this.builder = new WebHookTriggerBuilder(this);
            }
            GenericNestedImpl(WebHookTrigger item){
                    this.builder = new WebHookTriggerBuilder(this, item);
            }
    
    public N endGeneric(){
            return and();
    }
    public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGeneric(builder.build());
    }

}
    public class GithubNestedImpl<N> extends WebHookTriggerFluentImpl<BuildTriggerPolicyFluent.GithubNested<N>> implements BuildTriggerPolicyFluent.GithubNested<N>,Nested<N>{

            private final WebHookTriggerBuilder builder;
    
            GithubNestedImpl(){
                    this.builder = new WebHookTriggerBuilder(this);
            }
            GithubNestedImpl(WebHookTrigger item){
                    this.builder = new WebHookTriggerBuilder(this, item);
            }
    
    public N endGithub(){
            return and();
    }
    public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGithub(builder.build());
    }

}
    public class ImageChangeNestedImpl<N> extends ImageChangeTriggerFluentImpl<BuildTriggerPolicyFluent.ImageChangeNested<N>> implements BuildTriggerPolicyFluent.ImageChangeNested<N>,Nested<N>{

            private final ImageChangeTriggerBuilder builder;
    
            ImageChangeNestedImpl(){
                    this.builder = new ImageChangeTriggerBuilder(this);
            }
            ImageChangeNestedImpl(ImageChangeTrigger item){
                    this.builder = new ImageChangeTriggerBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withImageChange(builder.build());
    }
    public N endImageChange(){
            return and();
    }

}


}
