package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;

public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>> extends BaseFluent<A> implements BuildSpecFluent<A>{

    private Long completionDeadlineSeconds;
    private VisitableBuilder<? extends BuildOutput,?> output;
    private VisitableBuilder<? extends BuildPostCommitSpec,?> postCommit;
    private VisitableBuilder<? extends ResourceRequirements,?> resources;
    private VisitableBuilder<? extends SourceRevision,?> revision;
    private String serviceAccount;
    private VisitableBuilder<? extends BuildSource,?> source;
    private VisitableBuilder<? extends BuildStrategy,?> strategy;

    public BuildSpecFluentImpl(){
    }
    public BuildSpecFluentImpl(BuildSpec instance){
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
            this.withOutput(instance.getOutput()); 
            this.withPostCommit(instance.getPostCommit()); 
            this.withResources(instance.getResources()); 
            this.withRevision(instance.getRevision()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withSource(instance.getSource()); 
            this.withStrategy(instance.getStrategy()); 
    }

    public Long getCompletionDeadlineSeconds(){
            return this.completionDeadlineSeconds;
    }

    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds){
            this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
    }

    public BuildOutput getOutput(){
            return this.output!=null?this.output.build():null;
    }

    public A withOutput(BuildOutput output){
            if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (A) this;
    }

    public BuildSpecFluent.OutputNested<A> withNewOutput(){
            return new OutputNestedImpl();
    }

    public BuildSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item){
            return new OutputNestedImpl(item);
    }

    public BuildSpecFluent.OutputNested<A> editOutput(){
            return withNewOutputLike(getOutput());
    }

    public BuildPostCommitSpec getPostCommit(){
            return this.postCommit!=null?this.postCommit.build():null;
    }

    public A withPostCommit(BuildPostCommitSpec postCommit){
            if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.add(this.postCommit);} return (A) this;
    }

    public BuildSpecFluent.PostCommitNested<A> withNewPostCommit(){
            return new PostCommitNestedImpl();
    }

    public BuildSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item){
            return new PostCommitNestedImpl(item);
    }

    public BuildSpecFluent.PostCommitNested<A> editPostCommit(){
            return withNewPostCommitLike(getPostCommit());
    }

    public ResourceRequirements getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources){
            if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (A) this;
    }

    public BuildSpecFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public BuildSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item){
            return new ResourcesNestedImpl(item);
    }

    public BuildSpecFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public SourceRevision getRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public A withRevision(SourceRevision revision){
            if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }

    public BuildSpecFluent.RevisionNested<A> withNewRevision(){
            return new RevisionNestedImpl();
    }

    public BuildSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item){
            return new RevisionNestedImpl(item);
    }

    public BuildSpecFluent.RevisionNested<A> editRevision(){
            return withNewRevisionLike(getRevision());
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public BuildSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(BuildSource source){
            if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }

    public BuildSpecFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public BuildSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item){
            return new SourceNestedImpl(item);
    }

    public BuildSpecFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public BuildStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(BuildStrategy strategy){
            if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (A) this;
    }

    public BuildSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public BuildSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item){
            return new StrategyNestedImpl(item);
    }

    public BuildSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildSpecFluentImpl that = (BuildSpecFluentImpl) o;
            if (completionDeadlineSeconds != null ? !completionDeadlineSeconds.equals(that.completionDeadlineSeconds) :that.completionDeadlineSeconds != null) return false;
            if (output != null ? !output.equals(that.output) :that.output != null) return false;
            if (postCommit != null ? !postCommit.equals(that.postCommit) :that.postCommit != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            return true;
    }


    public class OutputNestedImpl<N> extends BuildOutputFluentImpl<BuildSpecFluent.OutputNested<N>> implements BuildSpecFluent.OutputNested<N>,Nested<N>{

            private final BuildOutputBuilder builder;
    
            OutputNestedImpl(){
                    this.builder = new BuildOutputBuilder(this);
            }
            OutputNestedImpl(BuildOutput item){
                    this.builder = new BuildOutputBuilder(this, item);
            }
    
    public N endOutput(){
            return and();
    }
    public N and(){
            return (N) BuildSpecFluentImpl.this.withOutput(builder.build());
    }

}
    public class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<BuildSpecFluent.PostCommitNested<N>> implements BuildSpecFluent.PostCommitNested<N>,Nested<N>{

            private final BuildPostCommitSpecBuilder builder;
    
            PostCommitNestedImpl(){
                    this.builder = new BuildPostCommitSpecBuilder(this);
            }
            PostCommitNestedImpl(BuildPostCommitSpec item){
                    this.builder = new BuildPostCommitSpecBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSpecFluentImpl.this.withPostCommit(builder.build());
    }
    public N endPostCommit(){
            return and();
    }

}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildSpecFluent.ResourcesNested<N>> implements BuildSpecFluent.ResourcesNested<N>,Nested<N>{

            private final ResourceRequirementsBuilder builder;
    
            ResourcesNestedImpl(){
                    this.builder = new ResourceRequirementsBuilder(this);
            }
            ResourcesNestedImpl(ResourceRequirements item){
                    this.builder = new ResourceRequirementsBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildSpecFluent.RevisionNested<N>> implements BuildSpecFluent.RevisionNested<N>,Nested<N>{

            private final SourceRevisionBuilder builder;
    
            RevisionNestedImpl(){
                    this.builder = new SourceRevisionBuilder(this);
            }
            RevisionNestedImpl(SourceRevision item){
                    this.builder = new SourceRevisionBuilder(this, item);
            }
    
    public N endRevision(){
            return and();
    }
    public N and(){
            return (N) BuildSpecFluentImpl.this.withRevision(builder.build());
    }

}
    public class SourceNestedImpl<N> extends BuildSourceFluentImpl<BuildSpecFluent.SourceNested<N>> implements BuildSpecFluent.SourceNested<N>,Nested<N>{

            private final BuildSourceBuilder builder;
    
            SourceNestedImpl(){
                    this.builder = new BuildSourceBuilder(this);
            }
            SourceNestedImpl(BuildSource item){
                    this.builder = new BuildSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) BuildSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<BuildSpecFluent.StrategyNested<N>> implements BuildSpecFluent.StrategyNested<N>,Nested<N>{

            private final BuildStrategyBuilder builder;
    
            StrategyNestedImpl(){
                    this.builder = new BuildStrategyBuilder(this);
            }
            StrategyNestedImpl(BuildStrategy item){
                    this.builder = new BuildStrategyBuilder(this, item);
            }
    
    public N endStrategy(){
            return and();
    }
    public N and(){
            return (N) BuildSpecFluentImpl.this.withStrategy(builder.build());
    }

}


}
