package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface BuildOutputFluent<A extends BuildOutputFluent<A>> extends Fluent<A>{


    public LocalObjectReference getPushSecret();
    public A withPushSecret(LocalObjectReference pushSecret);
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecret();
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item);
    public BuildOutputFluent.PushSecretNested<A> editPushSecret();
    public A withNewPushSecret(String name);
    public ObjectReference getTo();
    public A withTo(ObjectReference to);
    public BuildOutputFluent.ToNested<A> withNewTo();
    public BuildOutputFluent.ToNested<A> withNewToLike(ObjectReference item);
    public BuildOutputFluent.ToNested<A> editTo();

    public interface PushSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<BuildOutputFluent.PushSecretNested<N>>{

        
    public N endPushSecret();    public N and();
}
    public interface ToNested<N> extends Nested<N>,ObjectReferenceFluent<BuildOutputFluent.ToNested<N>>{

        
    public N and();    public N endTo();
}


}
