package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class BuildConfigStatusFluentImpl<A extends BuildConfigStatusFluent<A>> extends BaseFluent<A> implements BuildConfigStatusFluent<A>{

    private Integer lastVersion;

    public BuildConfigStatusFluentImpl(){
    }
    public BuildConfigStatusFluentImpl(BuildConfigStatus instance){
            this.withLastVersion(instance.getLastVersion()); 
    }

    public Integer getLastVersion(){
            return this.lastVersion;
    }

    public A withLastVersion(Integer lastVersion){
            this.lastVersion=lastVersion; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildConfigStatusFluentImpl that = (BuildConfigStatusFluentImpl) o;
            if (lastVersion != null ? !lastVersion.equals(that.lastVersion) :that.lastVersion != null) return false;
            return true;
    }




}
