package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface BuildConfigFluent<A extends BuildConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildConfigFluent.MetadataNested<A> withNewMetadata();
    public BuildConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildConfigFluent.MetadataNested<A> editMetadata();
    public BuildConfigSpec getSpec();
    public A withSpec(BuildConfigSpec spec);
    public BuildConfigFluent.SpecNested<A> withNewSpec();
    public BuildConfigFluent.SpecNested<A> withNewSpecLike(BuildConfigSpec item);
    public BuildConfigFluent.SpecNested<A> editSpec();
    public BuildConfigStatus getStatus();
    public A withStatus(BuildConfigStatus status);
    public BuildConfigFluent.StatusNested<A> withNewStatus();
    public BuildConfigFluent.StatusNested<A> withNewStatusLike(BuildConfigStatus item);
    public BuildConfigFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer lastVersion);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<BuildConfigFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,BuildConfigSpecFluent<BuildConfigFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,BuildConfigStatusFluent<BuildConfigFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
