package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class JobConditionFluentImpl<A extends JobConditionFluent<A>> extends BaseFluent<A> implements JobConditionFluent<A>{

    private String lastProbeTime;
    private String lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public JobConditionFluentImpl(){
    }
    public JobConditionFluentImpl(JobCondition instance){
            this.withLastProbeTime(instance.getLastProbeTime()); 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    public String getLastProbeTime(){
            return this.lastProbeTime;
    }

    public A withLastProbeTime(String lastProbeTime){
            this.lastProbeTime=lastProbeTime; return (A) this;
    }

    public String getLastTransitionTime(){
            return this.lastTransitionTime;
    }

    public A withLastTransitionTime(String lastTransitionTime){
            this.lastTransitionTime=lastTransitionTime; return (A) this;
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JobConditionFluentImpl that = (JobConditionFluentImpl) o;
            if (lastProbeTime != null ? !lastProbeTime.equals(that.lastProbeTime) :that.lastProbeTime != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
