package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface PersistentVolumeClaimStatusFluent<A extends PersistentVolumeClaimStatusFluent<A>> extends Fluent<A>{


    public A addToAccessModes(String... items);
    public A removeFromAccessModes(String... items);
    public List<String> getAccessModes();
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public String getPhase();
    public A withPhase(String phase);



}
