package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface NodeSystemInfoFluent<A extends NodeSystemInfoFluent<A>> extends Fluent<A>{


    public String getBootID();
    public A withBootID(String bootID);
    public String getContainerRuntimeVersion();
    public A withContainerRuntimeVersion(String containerRuntimeVersion);
    public String getKernelVersion();
    public A withKernelVersion(String kernelVersion);
    public String getKubeProxyVersion();
    public A withKubeProxyVersion(String kubeProxyVersion);
    public String getKubeletVersion();
    public A withKubeletVersion(String kubeletVersion);
    public String getMachineID();
    public A withMachineID(String machineID);
    public String getOsImage();
    public A withOsImage(String osImage);
    public String getSystemUUID();
    public A withSystemUUID(String systemUUID);



}
