package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class MetadataVolumeSourceBuilder extends MetadataVolumeSourceFluentImpl<MetadataVolumeSourceBuilder> implements VisitableBuilder<MetadataVolumeSource,MetadataVolumeSourceBuilder>{

    MetadataVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public MetadataVolumeSourceBuilder(){
            this(true);
    }
    public MetadataVolumeSourceBuilder(Boolean validationEnabled){
            this(new MetadataVolumeSource(), validationEnabled);
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetadataVolumeSource(), validationEnabled);
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent,MetadataVolumeSource instance){
            this(fluent, instance, true);
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSourceFluent<?> fluent,MetadataVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSource instance){
            this(instance,true);
    }
    public MetadataVolumeSourceBuilder(MetadataVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetadataVolumeSource build(){
            MetadataVolumeSource buildable = new MetadataVolumeSource(fluent.getItems());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetadataVolumeSourceBuilder that = (MetadataVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
