package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class HostPathVolumeSourceFluentImpl<A extends HostPathVolumeSourceFluent<A>> extends BaseFluent<A> implements HostPathVolumeSourceFluent<A>{

    private String path;

    public HostPathVolumeSourceFluentImpl(){
    }
    public HostPathVolumeSourceFluentImpl(HostPathVolumeSource instance){
            this.withPath(instance.getPath()); 
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HostPathVolumeSourceFluentImpl that = (HostPathVolumeSourceFluentImpl) o;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            return true;
    }




}
