package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class AuthInfoBuilder extends AuthInfoFluentImpl<AuthInfoBuilder> implements VisitableBuilder<AuthInfo,AuthInfoBuilder>{

    AuthInfoFluent<?> fluent;
    Boolean validationEnabled;

    public AuthInfoBuilder(){
            this(true);
    }
    public AuthInfoBuilder(Boolean validationEnabled){
            this(new AuthInfo(), validationEnabled);
    }
    public AuthInfoBuilder(AuthInfoFluent<?> fluent){
            this(fluent, true);
    }
    public AuthInfoBuilder(AuthInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthInfo(), validationEnabled);
    }
    public AuthInfoBuilder(AuthInfoFluent<?> fluent,AuthInfo instance){
            this(fluent, instance, true);
    }
    public AuthInfoBuilder(AuthInfoFluent<?> fluent,AuthInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAs(instance.getAs()); 
            fluent.withClientCertificate(instance.getClientCertificate()); 
            fluent.withClientCertificateData(instance.getClientCertificateData()); 
            fluent.withClientKey(instance.getClientKey()); 
            fluent.withClientKeyData(instance.getClientKeyData()); 
            fluent.withExtensions(instance.getExtensions()); 
            fluent.withPassword(instance.getPassword()); 
            fluent.withToken(instance.getToken()); 
            fluent.withUsername(instance.getUsername()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthInfoBuilder(AuthInfo instance){
            this(instance,true);
    }
    public AuthInfoBuilder(AuthInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAs(instance.getAs()); 
            this.withClientCertificate(instance.getClientCertificate()); 
            this.withClientCertificateData(instance.getClientCertificateData()); 
            this.withClientKey(instance.getClientKey()); 
            this.withClientKeyData(instance.getClientKeyData()); 
            this.withExtensions(instance.getExtensions()); 
            this.withPassword(instance.getPassword()); 
            this.withToken(instance.getToken()); 
            this.withUsername(instance.getUsername()); 
            this.validationEnabled = validationEnabled; 
    }

    public AuthInfo build(){
            AuthInfo buildable = new AuthInfo(fluent.getAs(),fluent.getClientCertificate(),fluent.getClientCertificateData(),fluent.getClientKey(),fluent.getClientKeyData(),fluent.getExtensions(),fluent.getPassword(),fluent.getToken(),fluent.getUsername());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthInfoBuilder that = (AuthInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
