package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Long;
import java.lang.Boolean;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface TagReferenceFluent<A extends TagReferenceFluent<A>> extends Fluent<A>{


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public TagReferenceFluent.FromNested<A> withNewFrom();
    public TagReferenceFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public TagReferenceFluent.FromNested<A> editFrom();
    public Long getGeneration();
    public A withGeneration(Long generation);
    public TagImportPolicy getImportPolicy();
    public A withImportPolicy(TagImportPolicy importPolicy);
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicy();
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item);
    public TagReferenceFluent.ImportPolicyNested<A> editImportPolicy();
    public A withNewImportPolicy(Boolean insecure,Boolean scheduled);
    public String getName();
    public A withName(String name);
    public Boolean isReference();
    public A withReference(Boolean reference);

    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<TagReferenceFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface ImportPolicyNested<N> extends Nested<N>,TagImportPolicyFluent<TagReferenceFluent.ImportPolicyNested<N>>{

        
    public N endImportPolicy();    public N and();
}


}
