package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface SecretSpecFluent<A extends SecretSpecFluent<A>> extends Fluent<A>{


    public String getMountPath();
    public A withMountPath(String mountPath);
    public LocalObjectReference getSecretSource();
    public A withSecretSource(LocalObjectReference secretSource);
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource();
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item);
    public SecretSpecFluent.SecretSourceNested<A> editSecretSource();
    public A withNewSecretSource(String name);

    public interface SecretSourceNested<N> extends Nested<N>,LocalObjectReferenceFluent<SecretSpecFluent.SecretSourceNested<N>>{

        
    public N endSecretSource();    public N and();
}


}
