package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface RouteSpecFluent<A extends RouteSpecFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public String getPath();
    public A withPath(String path);
    public RoutePort getPort();
    public A withPort(RoutePort port);
    public RouteSpecFluent.PortNested<A> withNewPort();
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item);
    public RouteSpecFluent.PortNested<A> editPort();
    public TLSConfig getTls();
    public A withTls(TLSConfig tls);
    public RouteSpecFluent.TlsNested<A> withNewTls();
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item);
    public RouteSpecFluent.TlsNested<A> editTls();
    public ObjectReference getTo();
    public A withTo(ObjectReference to);
    public RouteSpecFluent.ToNested<A> withNewTo();
    public RouteSpecFluent.ToNested<A> withNewToLike(ObjectReference item);
    public RouteSpecFluent.ToNested<A> editTo();

    public interface PortNested<N> extends Nested<N>,RoutePortFluent<RouteSpecFluent.PortNested<N>>{

        
    public N endPort();    public N and();
}
    public interface TlsNested<N> extends Nested<N>,TLSConfigFluent<RouteSpecFluent.TlsNested<N>>{

        
    public N endTls();    public N and();
}
    public interface ToNested<N> extends Nested<N>,ObjectReferenceFluent<RouteSpecFluent.ToNested<N>>{

        
    public N and();    public N endTo();
}


}
