package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class GitBuildSourceBuilder extends GitBuildSourceFluentImpl<GitBuildSourceBuilder> implements VisitableBuilder<GitBuildSource,GitBuildSourceBuilder>{

    GitBuildSourceFluent<?> fluent;
    Boolean validationEnabled;

    public GitBuildSourceBuilder(){
            this(true);
    }
    public GitBuildSourceBuilder(Boolean validationEnabled){
            this(new GitBuildSource(), validationEnabled);
    }
    public GitBuildSourceBuilder(GitBuildSourceFluent<?> fluent){
            this(fluent, true);
    }
    public GitBuildSourceBuilder(GitBuildSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GitBuildSource(), validationEnabled);
    }
    public GitBuildSourceBuilder(GitBuildSourceFluent<?> fluent,GitBuildSource instance){
            this(fluent, instance, true);
    }
    public GitBuildSourceBuilder(GitBuildSourceFluent<?> fluent,GitBuildSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpProxy(instance.getHttpProxy()); 
            fluent.withHttpsProxy(instance.getHttpsProxy()); 
            fluent.withRef(instance.getRef()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public GitBuildSourceBuilder(GitBuildSource instance){
            this(instance,true);
    }
    public GitBuildSourceBuilder(GitBuildSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpProxy(instance.getHttpProxy()); 
            this.withHttpsProxy(instance.getHttpsProxy()); 
            this.withRef(instance.getRef()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public GitBuildSource build(){
            GitBuildSource buildable = new GitBuildSource(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getRef(),fluent.getUri());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GitBuildSourceBuilder that = (GitBuildSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
