package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class DeploymentConfigSpecBuilder extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder> implements VisitableBuilder<DeploymentConfigSpec,DeploymentConfigSpecBuilder>{

    DeploymentConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigSpecBuilder(){
            this(true);
    }
    public DeploymentConfigSpecBuilder(Boolean validationEnabled){
            this(new DeploymentConfigSpec(), validationEnabled);
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeploymentConfigSpec(), validationEnabled);
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,DeploymentConfigSpec instance){
            this(fluent, instance, true);
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,DeploymentConfigSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withStrategy(instance.getStrategy()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withTest(instance.getTest()); 
            fluent.withTriggers(instance.getTriggers()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance){
            this(instance,true);
    }
    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withStrategy(instance.getStrategy()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTest(instance.getTest()); 
            this.withTriggers(instance.getTriggers()); 
            this.validationEnabled = validationEnabled; 
    }

    public DeploymentConfigSpec build(){
            DeploymentConfigSpec buildable = new DeploymentConfigSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.isTest(),fluent.getTriggers());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
