package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class BinaryBuildSourceFluentImpl<A extends BinaryBuildSourceFluent<A>> extends BaseFluent<A> implements BinaryBuildSourceFluent<A>{

    private String asFile;

    public BinaryBuildSourceFluentImpl(){
    }
    public BinaryBuildSourceFluentImpl(BinaryBuildSource instance){
            this.withAsFile(instance.getAsFile()); 
    }

    public String getAsFile(){
            return this.asFile;
    }

    public A withAsFile(String asFile){
            this.asFile=asFile; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BinaryBuildSourceFluentImpl that = (BinaryBuildSourceFluentImpl) o;
            if (asFile != null ? !asFile.equals(that.asFile) :that.asFile != null) return false;
            return true;
    }




}
