package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder;

public class IngressStatusFluentImpl<A extends IngressStatusFluent<A>> extends BaseFluent<A> implements IngressStatusFluent<A>{

    private VisitableBuilder<? extends LoadBalancerStatus,?> loadBalancer;

    public IngressStatusFluentImpl(){
    }
    public IngressStatusFluentImpl(IngressStatus instance){
            this.withLoadBalancer(instance.getLoadBalancer()); 
    }

    public LoadBalancerStatus getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(LoadBalancerStatus loadBalancer){
            if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStatusBuilder(loadBalancer); _visitables.add(this.loadBalancer);} return (A) this;
    }

    public IngressStatusFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public IngressStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item){
            return new LoadBalancerNestedImpl(item);
    }

    public IngressStatusFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressStatusFluentImpl that = (IngressStatusFluentImpl) o;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            return true;
    }


    public class LoadBalancerNestedImpl<N> extends LoadBalancerStatusFluentImpl<IngressStatusFluent.LoadBalancerNested<N>> implements IngressStatusFluent.LoadBalancerNested<N>,Nested<N>{

            private final LoadBalancerStatusBuilder builder;
    
            LoadBalancerNestedImpl(){
                    this.builder = new LoadBalancerStatusBuilder(this);
            }
            LoadBalancerNestedImpl(LoadBalancerStatus item){
                    this.builder = new LoadBalancerStatusBuilder(this, item);
            }
    
    public N and(){
            return (N) IngressStatusFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}


}
